﻿/*
VERSION:	1.1

USAGE:
	#include "makeGrayscale.as"
	grayImage_pic = makeGrayscale( colorImage_pic );
	
NOTE:
	This effect is slow.
	It took 0.49 seconds to affect Miyamoto.  (averaged measurement from 4 tries)
	(Fastest possible time with Zero processing is:  0.248 seconds)
*/



makeGrayscale = function( input_pic )
{
	// copy the image
	var output_pic = input_pic.clone();
	
	
	for (var y = 0; y < output_pic.height; ++y)
	{
		for (var x = 0; x < output_pic.width; ++x)
		{
			// read color
			var colorNum = output_pic.getPixel(x, y);
			// read RGB of this color
			var redNum = (colorNum & 0xff0000) >> 16;
			var greenNum = (colorNum & 0x00ff00) >> 8;
			var blueNum = (colorNum & 0x0000ff);
			
			// find average gray tone
			var averageValue = (redNum + greenNum + blueNum) / 3;
			
			// construct hex color
			var averageColorNum = (averageValue<<16) | (averageValue<<8) | (averageValue);
			
			// write gray pixel
			output_pic.setPixel(x, y, averageColorNum);
		}// for:  x
	}// for:  y
	
	
	return output_pic;
}// makeGrayscale()